#ifndef _MEMSTRUCT
#define _MEMSTRUCT

//#include "datatype.h"
#ifdef _MSC_VER   
#define __packed   
#pragma pack(1)   
#endif 

typedef unsigned long	u32;
typedef signed long	s32;
typedef unsigned short	u16;
typedef signed short	s16;
typedef unsigned char u8;
typedef signed char s8;

#define MODEL_MAX	2
typedef  struct _SYSTEM
{
	u16 TempUnit;					//¶ȵλ
	u16 TempStop;					//ͣ¶
	u16 TempFansOn;					//ȿ¶
	u16 TempReduce;					//˥¶
	u16 FansSpeed;					//תǿ
	u16 FansOffDelay;				//ȹرʱ 
	u16 LcdContraste;				//LCDԱȶ
	u16 LightValue;					//ǿ
	u16 BeepMode;					//ʾ DEL
	u16 BeepType[4];				// ,,
	u16 BeepEnable[4];				// ,ʾ,,
	u16 BeepVOL[4];					// ,ʾ,,
	u16 DoneBeepType;				// 5,3,һֱ,ر
	u16 SelectAdj;					//ǰУ׼ֵ =0:ϵͳУ׼ֵ; =1:ûУ׼ֵ
	u16 Ver;						//ϵͳİ汾
	u16 SelInputSource;				//Դѡ =0:DC =1:Bat. =2:ûѡ
	u16 DCInputLowVolt;				//DCѹѹ
	u16 DCInputOverVolt;			//DCѹѹ
	s16 DCInputCurrentLimit;		//DC
	u16 BatInputLowVolt;			//BATѹѹ
	u16 BatInputOverVolt;			//BATѹѹ
	s16 BatInputCurrentLimit;		//BAT
	u16 RegEnable;					//
	u16 RegVoltLimit;				//յѹ
	s16	RegCurrentLimit;			//յ
	u16 ChargePower[MODEL_MAX];		//繦
	u16 DischargePower[MODEL_MAX];	//ŵ繦
	u16 ProPower;					//ʷȼ 0=ƽ; 1=CH1; 2=CH2
	u16 MonitorLogInterval[MODEL_MAX];			// 0.1S Ϊ1λ
	u16 MonitorLogSaveToSD[MODEL_MAX];			//=0:logSD =1:logSD

	u16 ServoType;			//
	u16 ServoUserCenter;	//ĵ
	u16 ServoUserRate;		//֡ˢ
	u16 ServoUserOpAngle;	//45
	
	u16 ModBusMode;		//=0:ModBus =1:HID ModBus =2:Serial ModBus
	u16 ModBusAddr;		//ͨѶʱĵַ


	u16 Dump[10];					//
}SYSTEM;

#define LIST_MEM_MAX		64
typedef struct _MEM_HEAD
{
	u16 Count;
	u8 Index[LIST_MEM_MAX];//0xffʾ 0xfeʶ  0-LIST_MEM_MAX
}MEM_HEAD;
#define MEM_HEAD_DEFAULT	{7,{0,1,2,3,4,5,6}}

enum{
	BAL_START_CV,
	BAL_START_CV_100,
	BAL_START_CV_200,
	BAL_START_CV_300,
	BAL_START_CV_400,
	BAL_START_CV_500,
	BAL_START_CV_600,
	BAL_START_CV_700,
	BAL_START_CV_800,
	BAL_START_CV_900,
	BAL_START_CV_1000,
	BAL_START_ALWAY,
};

enum{
	BAL_SPEED_SLOW,
	BAL_SPEED_NORMAL,
	BAL_SPEED_FAST,
	BAL_SPEED_USER,
};

enum{
	LI_MODE_C_BAL,	//ƽ
	LI_MODE_C_NOTBAL,//粻ƽ
};

enum{
	NI_MODE_C_NORMAL,
	NI_MODE_C_REFLEX,
};

enum{
	PB_MODE_C_NORMAL,
	PB_MODE_C_REFLEX,
};

enum{
	CYCLE_MODE_C2D,
	CYCLE_MODE_D2C,
};

enum{
	REG_DCHG_OFF,
	REG_DCHG_INPUT,
	REG_DCHG_CH,
	REG_DCHG_AUTO,
};

#define MEM_NAME_LEN	37
typedef __packed struct _MEMORY
{
	u16 UseFlag;					//ʹñ
	s8 Name[MEM_NAME_LEN+1];		//
	u32 Capacity;					//
	u8 AutoSave;					//Զ
	u8 LiBalEndMode;				//Liƽģʽ
	u8 LockFlag;					//
	u8 LockPWD[6];					//
	u16 OpEnable;					//ģǷʹ:bit0-15λֱʾCharge(bit0) ,Storage(bit2) ,Discharge(bit3) ,Cycle(bit4) ,OnlyBalance(bit5) 

	u8 ChannelMode;					//CH1|CH2,CH1&CH2,CH1,CH2	
	u8 SaveToSD;					//=0:logSD =1:logSD
	u16 LogInterval;				// 0.1S Ϊ1λ
	u16 RunCounter;					//дͳ 

	u8 Type;						//: LiPo,LiLo,LiFe,NiMH,Nicd,Pb
	u8 LiCell;						//Liش
	u8 NiCell;						//Niش
	u8 PbCell;						//Pbش

	u8 LiModeC;						//ģʽ: Normal,Balance
	u8 LiModeD;						//ŵģʽ: Normal,Balance,External
	u8 NiModeC;						//ģʽ: Normal,REFLEX
	u8 NiModeD;						//ŵģʽ: 
	u8 PbModeC;						//ģʽ: Normal,REFLEX
	u8 PbModeD;						//ŵģʽ: 

	u8 BalSpeed;					//ƽٶ: 0--slow 1--normal 2--fast
	u8 BalStartMode;				//ƽʼģʽ: 0-- 1--CV׶ 2--ָʼѹ 
	u16 BalStartVolt;				//ƽʼѹ
	u8 BalDiff;						//ƽֹͣ(mV)
	u8 BalOverPoint;				//ƽѹֵ
	u8 BalSetPoint;					//ƽʱѹֵ.: 4.2VLiPo,BalSetPoint=5,Ǿ4.195Vֹͣ
	u8 BalDelay;					//ƽƳٽʱ
	
	u8 KeepChargeEnable;			//

	u16 LiPoChgCellVolt;			//LiPoصѹ
	u16 LiLoChgCellVolt;			//LiLoصѹ
	u16 LiFeChgCellVolt;			//LiFeصѹ
	
	u16 LiPoStoCellVolt;			//LiPoص洢ѹ
	u16 LiLoStoCellVolt;			//LiLoص洢ѹ
	u16 LiFeStoCellVolt;			//LiFeص洢ѹ

	u16 LiPoDchgCellVolt;			//LiPoŵ絥ֹѹ
	u16 LiLoDchgCellVolt;			//LiLoŵ絥ֹѹ
	u16 LiFeDchgCellVolt;			//LiFeŵ絥ֹѹ

	u16 ChargeCurrent;				//ó
	u16 DischargeCurrent;			//÷ŵ

	u16 EndCharge;					//
	u16 EndDischarge;				//ŵ
	u16 RegDchgMode;				//ŵģʽ: OFF(ڲŵ),յŵ,յͨ,Զ

	u16 NiPeak;						// еѹ
	u16 NiPeakDelay;				// deltaVӳ

	u16 NiTrickleEnable;			//
	u16 NiTrickleCurrent;			//
	u16 NiTrickleTime;				//ʱ

	u16 NiZeroEnable;				//Ni0ѹ(ڷж)
	
	u16 NiDischargeVolt;			//Niŵѹ
	u16 PbChgCellVolt;				//Pbصѹ
	u16 PbDchgCellVolt;				//Pbصŵѹ
	u16 PbFloatEnable;				//Pbص帡
	u16 PbFloatCellVolt;			//Pbص帡ѹ

	u16 RestoreVolt;				//ѹָѹ
	u16 RestoreTime;				//ѹָʱ
	u16 RestoreCurent;				//ѹָ
	//
	//ѭ
	u16 CycleCount;					//ѭ
	u16 CycleDelay;					//ѭʱ
	u8 CycleMode;					//ѭģʽ
	
	//ȫ
	u16 SafetyTimeC;				//ȫʱ
	u16	SafetyCapC;					//ȫ%
	u16 SafetyTempC;				//ȫ¶
	u16 SafetyTimeD;				//ȫʱ
	u16	SafetyCapD;					//ȫ%
	u16 SafetyTempD;				//ȫ¶

//#ifdef REG_CH
	u8 RegChMode;					//ͨģʽ
	u16 RegChVolt;					//ͨƵѹ
	u16 RegChCurrent;				//ͨƵ
//#endif

//#ifdef FAST_STO
	u8 FastSto;						//﮵ش洢	
	u16 StoCompensation;			//洢ѹ
//#endif

//#ifdef NIZN
	u16 NiZnChgCellVolt;			//NiZnصѹ
	u16 NiZnDchgCellVolt;			//NiZnŵ絥ֹѹ
	u8 NiZnCell;					//NiZnش
//#endif
	u8 Dump;		//Ҫ,ṹҪΪ˫,洢ܶʧ

}MEMORY;

#define NI_ZERO_VOLT		500	   //NI0ѹ׼

#define CAP_MIN				0
#define CAP_MAX				999900
#define CAP_STEP			100
#define CAP_DEFAULT			0

#define RUN_COUNT_MIN				0
#define RUN_COUNT_MAX				999
#define RUN_COUNT_STEP				1
#define RUN_COUNT_DEFAULT			0

#define LOG_INTERVAL_MIN				5
#define LOG_INTERVAL_MAX				600
#define LOG_INTERVAL_STEP				5
#define LOG_INTERVAL_DEFAULT			10

#define BT_TYPE_MIN				0
#define BT_TYPE_MAX				(BT_MAX-1)
#define BT_TYPE_STEP			1
#define BT_TYPE_DEFAULT			0

#define LI_CELLS_MIN	   0
#define LI_CELLS_MAX	   CELL_MAX
#define LI_CELLS_DEFAULT   0

#define NI_CELLS_MIN	   0
#define NI_CELLS_MAX	   HW_NI_CELLS_MAX
#define NI_CELLS_DEFAULT   0

#define PB_CELLS_MIN	   1
#define PB_CELLS_MAX	   HW_PB_CELLS_MAX
#define PB_CELLS_DEFAULT   6

#define RESTORE_VOLT_MIN		500  //ѹָѹMIN
#define RESTORE_VOLT_MAX		2500  //ѹָѹMAX
#define RESTORE_VOLT_DEFAULT	1000

#define RESTORE_TIME_MIN		1 //ѹָʱMIN
#define RESTORE_TIME_MAX		5 //ѹָʱMAX
#define RESTORE_TIME_DEFAULT	3

#define RESTORE_CURRENT_MIN		2  //ѹָMIN
#define RESTORE_CURRENT_MAX		50	//ѹָMAX
#define RESTORE_CURRENT_DEFAULT	10

//#ifdef NIZN
#define NIZN_CELLS_MIN		0
#define NIZN_CELLS_MAX		CELL_MAX
#define NIZN_CELLS_DEFAULT  0

#define NIZN_CHG_MIN		1200
#define NIZN_CHG_MAX		2000
#define NIZN_CHG_DEFAULT	1900

#define NIZN_DCHG_MIN		900
#define NIZN_DCHG_MAX		1600
#define NIZN_DCHG_DEFAULT	1100

#define NIZN_STD			1650
#define NIZN_MIN			RESTORE_VOLT_MIN
#define NIZN_MAX			(NIZN_CHG_MAX+50)
//#endif

//#define LITYPE_FE			2
#define LI_BAL_VOLT_MIN			3000
#define LI_BAL_VOLT_MAX			4200
#define LI_BAL_VOLT_DEFAULT		3500

#define LI_BAL_DIFF_MIN			1
#define LI_BAL_DIFF_MAX			10
#define LI_BAL_DIFF_DEFAULT		5

#define LI_BAL_SETPOINT_MIN			1
#define LI_BAL_SETPOINT_MAX			50
#define LI_BAL_SETPOINT_DEFAULT		5

#define LI_BAL_DELAY_MIN			0
#define LI_BAL_DELAY_MAX			20
#define LI_BAL_DELAY_DEFAULT		1

#define LI_BAL_OVER_MIN			0
#define LI_BAL_OVER_MAX			10
#define LI_BAL_OVER_DEFAULT		0

#define LIFE_CHG_MIN		3300
#define LIFE_CHG_MAX		3800
#define LIFE_CHG_DEFAULT	3600

#define LIFE_STO_MIN		3100
#define LIFE_STO_MAX		3400
#define LIFE_STO_DEFAULT	3300

#define LIFE_DCHG_MIN		2000
#define LIFE_DCHG_MAX		3500
#define LIFE_DCHG_DEFAULT	2500

#define LIFE_STD			3300
#define LIFE_MIN			RESTORE_VOLT_MIN
#define LIFE_MAX			(LIFE_CHG_MAX+50)

#define LIFE_ADJ_STEP		1

//#define LITYPE_LO			1
#define LIIO_CHG_MIN		3750
#define LIIO_CHG_MAX		4350
#define LIIO_CHG_DEFAULT	4100

#define LIIO_STO_MIN		3600
#define LIIO_STO_MAX		3800
#define LIIO_STO_DEFAULT	3750

#define LIIO_DCHG_MIN		2500
#define LIIO_DCHG_MAX		4000
#define LIIO_DCHG_DEFAULT	3500

#define LIIO_STD			3600
#define LIIO_MIN			RESTORE_VOLT_MIN
#define LIIO_MAX			(LIIO_CHG_MAX+50)

#define LIIO_ADJ_STEP		1

#define LIPO_CHG_MIN		3850
#define LIPO_CHG_MAX		4350
#define LIPO_CHG_DEFAULT	4200

#define LIPO_STO_MIN		3700
#define LIPO_STO_MAX		3900
#define LIPO_STO_DEFAULT	3850

#define LI_STO_COMP_MIN		0
#define LI_STO_COMP_MAX		200
#define LI_STO_COMP_DEFAULT	10

#define LIPO_DCHG_MIN		3000
#define LIPO_DCHG_MAX		4100
#define LIPO_DCHG_DEFAULT	3500

#define LIPO_STD			3700
#define LIPO_MIN			RESTORE_VOLT_MIN
#define LIPO_MAX			(LIPO_CHG_MAX+50)

#define LIPO_ADJ_STEP		1

#define NI_STD				1200

#define PB_STD				2000

#define PB_CHG_MIN			2000
#define PB_CHG_MAX			2600
#define PB_CHG_DEFAULT		2400

#define PB_FLOAT_MIN		2200
#define PB_FLOAT_MAX		2400
#define PB_FLOAT_DEFAULT	2300

#define PB_DCHG_MIN			1500
#define PB_DCHG_MAX			2400
#define PB_DCHG_DEFAULT		1800

#define PB_ADJ_STEP			1

#define MEM_EMPTY			0xffff
#define MEM_USED			0x55aa
#define MEM_FIXED			0x0000
#define MEM_SIZE			256

#define CYCLE_COUNT_MIN		1		//ѭMIN
#define CYCLE_COUNT_MAX		99 //ѭMAX
#define CYCLE_COUNT_DEFAULT	3

#define CYCLE_TIME_MIN		0		//ѭʱMIN
#define CYCLE_TIME_MAX		9999 //ѭʱMAX
#define CYCLE_TIME_DEFAULT	3

#define	SAFETY_TEMP_MIN		200	//ȫ¶MIN
#define	SAFETY_TEMP_MAX		800 //ȫ¶MAX
#define	SAFETY_TEMP_DEFAULT	450

#define	SAFETY_CAP_MIN		50	//ȫMIN
#define	SAFETY_CAP_MAX		200 //ȫMAX
#define	SAFETY_CAP_DEFAULT	120

#define	SAFETY_TIME_MIN		0	//ȫʱMIN
#define	SAFETY_TIME_MAX		9999 //ȫʱMAX
#define	SAFETY_TIME_DEFAULT	0

#define	END_CURRENT_C_MIN		1	//MIN
#define	END_CURRENT_C_MAX		50 	//MAX
#define	END_CURRENT_C_DEFAULT	10

#define	END_CURRENT_D_MIN		1	//ŵMIN
#define	END_CURRENT_D_MAX		100 //ŵMAX
#define	END_CURRENT_D_DEFAULT	50

#define END_CURRENT_STO_MAX	10		//洢ٷֱ

#define	CURRENT_MIN			5	//ŵMIN
#define	CURRENT_MAX			(SET_CURRENT_MAX) //ŵMAX
#define	CURRENT_DEFAULT		200
#define CURRENT_SYN_MAX		SET_ALL_CURRENT_MAX //ͬģʽŵMAX

#define	VOLT_D_MIN 				100
#define	VOLT_D_MAX 				40000
#define	VOLT_D_DEFAULT			10

#define NI_PEAK_SENS_MIN		1
#define NI_PEAK_SENS_MAX		20
#define NIMH_PEAK_SENS_DEFAULT	3
#define NICD_PEAK_SENS_DEFAULT	5

#define NI_PEAK_DELAY_MIN		0
#define NI_PEAK_DELAY_MAX		20
#define NI_PEAK_DELAY_DEFAULT	3

#define NI_TRICKLE_CURRENT_MIN			2
#define NI_TRICKLE_CURRENT_MAX			100
#define NI_TRICKLE_CURRENT_DEFAULT		5

#define NI_TRICKLE_TIME_MIN			1
#define NI_TRICKLE_TIME_MAX			999
#define NI_TRICKLE_TIME_DEFAULT		5

#define BAL_DIFF_SLOW			3
#define BAL_POINT_SLOW			3
#define BAL_OVER_SLOW			0
#define BAL_DELAY_SLOW			2

#define BAL_DIFF_NORMAL			LI_BAL_DIFF_DEFAULT
#define BAL_POINT_NORMAL		LI_BAL_SETPOINT_DEFAULT
#define BAL_OVER_NORMAL			LI_BAL_OVER_DEFAULT	
#define BAL_DELAY_NORMAL		LI_BAL_DELAY_DEFAULT	

#define BAL_DIFF_FAST			8
#define BAL_POINT_FAST			8
#define BAL_OVER_FAST			5
#define BAL_DELAY_FAST			0

enum
{
	REG_CH_TYPE_RES,
	REG_CH_TYPE_BAT,
};
#define REG_CH_VOLT_DEFAULT		12000
#define REG_CH_CURRENT_DEFAULT	100

#define MEMORY_DEFAULT {															\
	MEM_USED,						/*ʹñ*/									\
	{0},							/**/									\
	CAP_DEFAULT,			/**/									\
	0,								/*Զ*/								\
	0,							/*Liƽģʽ*/								\
	0xff,							/**/								\
	{0xff,0xff,0xff,0xff,0xff,0xff},			/**/								\
	0xffff,							/*ģǷʹ*/								\
	0,								/*ͨѡ*/								\
	1,								/*=0:logSD =1:logSD*/				\
	LOG_INTERVAL_DEFAULT,			/*0.1SΪ1λ*/						\
	RUN_COUNT_DEFAULT,								/*дͳ*/								\
	BT_TYPE_DEFAULT,								/*: LiPo,LiLo,LiFe,NiMH,Nicd,Pb*/			\
	LI_CELLS_DEFAULT,								/*Liش*/									\
	NI_CELLS_DEFAULT,								/*Niش*/									\
	PB_CELLS_DEFAULT,								/*Pbش*/									\
	LI_MODE_C_BAL,					/*Liģʽ:Not Balance,Balance*/			\
	0,								/*Liŵģʽ: Normal,Balance,External*/						\
	NI_MODE_C_NORMAL,				/*Niģʽ*/									\
	0,								/*Niŵģʽ*/									\
	0,								/*Pbģʽ*/									\
	0,								/*Pbŵģʽ*/									\
	BAL_SPEED_NORMAL,		/*ƽٶ*/  \
	BAL_START_CV_200,							/*ƽʼģʽ*/									\
	LI_BAL_VOLT_DEFAULT,			/*ƽʼѹ*/								\
	LI_BAL_DIFF_DEFAULT,			/*ƽֹͣ(mV)*/							\
	LI_BAL_OVER_DEFAULT,			/*ƽ(mV)*/							\
	LI_BAL_SETPOINT_DEFAULT,		/*ƽʱѹֵ*/			\
	LI_BAL_DELAY_DEFAULT,			/*ƽƳٽʱ*/							\
	0,								/**/										\
	LIPO_CHG_DEFAULT,				/*LiPoصѹ*/						\
	LIIO_CHG_DEFAULT,				/*LiLoصѹ*/						\
	LIFE_CHG_DEFAULT,				/*LiFeصѹ*/						\
	LIPO_STO_DEFAULT,				/*LiPoص洢ѹ*/						\
	LIIO_STO_DEFAULT,				/*LiLoص洢ѹ*/						\
	LIFE_STO_DEFAULT,				/*LiFeص洢ѹ*/						\
	LIPO_DCHG_DEFAULT,				/*LiPoŵ絥ֹѹ*/						\
	LIIO_DCHG_DEFAULT,				/*LiLoŵ絥ֹѹ*/						\
	LIFE_DCHG_DEFAULT,				/*LiFeŵ絥ֹѹ*/						\
	CURRENT_DEFAULT,				/*ó*/								\
	CURRENT_DEFAULT,				/*÷ŵ*/								\
	END_CURRENT_C_DEFAULT,			/*EndCharge*/						\
	END_CURRENT_D_DEFAULT,			/*EndDischargeŵ*/					\
	REG_DCHG_OFF,					/*RegDchgModeŵģʽ*/							\
	NIMH_PEAK_SENS_DEFAULT,			/*еѹ*/								\
	NI_PEAK_DELAY_DEFAULT,			/*deltaVӳ*/								\
	0,								/**/								\
	NI_TRICKLE_CURRENT_DEFAULT,		/**/								\
	NI_TRICKLE_TIME_DEFAULT,		/*ʱ*/								\
	0,								/*Ni0ѹ(ڷж)*/		\
	VOLT_D_DEFAULT,					/*NiMHŵѹ*/								\
	PB_CHG_DEFAULT,					/*Pbصѹ*/							\
	PB_DCHG_DEFAULT,				/*Pbصŵѹ*/							\
	0,								/*Pbص帡*/							\
	PB_FLOAT_DEFAULT,				/*Pbص帡ѹ*/							\
	RESTORE_VOLT_DEFAULT,			/*ѹָѹ*/								\
	RESTORE_TIME_DEFAULT,			/*ѹָʱ*/								\
	RESTORE_CURRENT_DEFAULT,		/*ѹָ*/								\
	CYCLE_COUNT_DEFAULT,			/*ѭ*/									\
	CYCLE_TIME_DEFAULT,				/*ѭʱ*/								\
	CYCLE_MODE_C2D,					/*ѭģʽ*/									\
	SAFETY_TIME_DEFAULT,			/*ȫʱ*/									\
	SAFETY_CAP_DEFAULT,				/*ȫ*/									\
	SAFETY_TEMP_DEFAULT,			/*ȫ¶*/									\
	SAFETY_TIME_DEFAULT,			/*ȫʱ*/									\
	SAFETY_CAP_DEFAULT,				/*ȫ*/									\
	SAFETY_TEMP_DEFAULT,			/*ȫ¶*/									\
	REG_CH_TYPE_RES,				/*ͨģʽ*/								\
	REG_CH_VOLT_DEFAULT,			/*ͨƵѹ*/							\
	REG_CH_CURRENT_DEFAULT,			/*ͨƵ*/							\
	1,								/*﮵ش洢*/								\
	LI_STO_COMP_DEFAULT,			/*洢ѹ*/								\
	NIZN_CHG_DEFAULT,			/*NiZnصѹ*/							\
	NIZN_DCHG_DEFAULT,			/*NiZnŵ絥ֹѹ*/							\
	NIZN_CELLS_DEFAULT,			/*NiZnش*/									\
	0xff,										/*˫*/		\
}


#endif //MEMSTRUCT

